<?php

// Include your database connection

include("db.php");



// Start the session

session_start();



// Set content type to JSON

header('Content-Type: application/json');

header("Access-Control-Allow-Origin: *");

header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

header("Access-Control-Allow-Headers: Content-Type");



// Enable error reporting for debugging

ini_set('display_errors', 1);

error_reporting(E_ALL);



// Base query without filters

$sql = "SELECT 

p.Product_id, 

p.Product_name, 

p.SKU, 

p.Selling_price,

p.MRP, 

p.qty, 

p.Product_image, 

p.variant_id,
p.Variant, 

p.Discount_percentage,
p.category,
p.displayplace,
s.Seo_title,

s.Seo_description

FROM product p

LEFT JOIN product_seo s ON p.Product_id = s.Product_id 

WHERE p.Delete_status = 0 AND p.mode = 1 ";

 // Default sorting



// Execute the query

$result = $conn->query($sql);



// Prepare the response

if ($result && $result->num_rows > 0) {

    $products = [];

    while ($row = $result->fetch_assoc()) {

        $variantCount = !empty($row['variant_id']) ? count(explode(',', $row['variant_id'])) : 0;

        $products[] = [

            'id' => $row['Product_id'],

            'productname' => $row['Product_name'],

            'sku' => $row['SKU'],

            'saleprice' => $row['Selling_price'],

            'mrp' => $row['MRP'],

            'qty' => $row['qty'] ?: '0', 

            'productimg' => $row['Product_image'],
            'display' => $row['displayplace'],
            'weight' => $row['Discount_percentage'],
            'category' => $row['category'],
            'variant' => $row['Variant'],

           'seo_title' => $row['Seo_title'],

           'seo_description' => $row['Seo_description']

        ];

    }

    echo json_encode(['status' => 'success', 'data' => $products]);

} else {

    echo json_encode(['status' => 'error', 'message' => 'No products found']);

}

?>

